# ImageSetBackgroundColor()

Sets the background color for the image.

The background color is used for clearing a region.

Setting the background color only affects the subsequent [ImageClearRect()](imageclearrect.md) calls

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageSetBackgroundColor( image=any, color=string );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| color | string | Yes | Background color (The default value is "black"): - Hexadecimal value of RGB color. For example, specify the color white as ##FFFFFF or FFFFFF. - String value of color (for example, "black", "red", "green"). - List of three numbers for (R,G,B) values. Each value must be in the range 0-255. *Alias: colour* |  |

# Examples

```cfml
img=imageNew("",200,200,"RGB","26de81");
imageSetBackGroundColor(img,"fed330");
imageClearRect(img,20,20,100,100);
cfimage(action="writeToBrowser",source=img);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[ImageClearRect()](imageclearrect.md), [image.setBackgroundColor()](../objects/image/setbackgroundcolor.md)