# ImageSetAntialiasing()

Switches antialiasing on or off in rendered graphics.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageSetAntialiasing( image=any, antialias=string );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| antialias | string | No | Antialiasing switch: - on,true: (default) - off,false: | on |

# Examples

```cfml
	imgObj = imageNew("",200,200,"rgb","149c82");
 	imgObj.setAntialiasing('off');
 	cfimage(action="writeToBrowser", source=imgObj);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.setAntialiasing()](../objects/image/setantialiasing.md)