# ImageScaleToFit()

Creates a resized image with the aspect ratio maintained.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageScaleToFit( image=any, fitWidth=string, fitHeight=string, interpolation=string, blurFactor=number );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| fitWidth | string | Yes | The width of the bounding box in pixels. You can specify an integer, or an empty string ("") if the fitHeight is specified. |  |
| fitHeight | string | Yes | The height of the bounding box in pixels. You can specify an integer, or an empty string ("") if the fitWidth is specified. |  |
| interpolation | string | No | The interpolation method for resampling. You can specify a specific interpolation algorithm by name (for example, hamming), by image quality (for example, mediumQuality), or by performance (for example, highestPerformance). Valid values are: - highestQuality (default) - highQuality - mediumQuality - highestPerformance - highPerformance - mediumPerformance - nearest - bilinear - bicubic - bessel - blackman - hamming - hanning - hermite - lanczos - mitchell - quadratic | automatic |
| blurFactor | number | No | The blur factor used for resampling. The higher the blur factor, the more blurred the image (also, the longer it takes to resize the image). Valid values are 1-10. | 1 |

# Examples

```cfml
myImg = imageNew("",400,400,"rgb","70a1ff");
imageScaleToFit(myImg,80,"","hamming");
cfimage(action="writeToBrowser", source=myImg);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.scaleToFit()](../objects/image/scaletofit.md)