# ImageRotateDrawingAxis()

Rotates all subsequent drawing on an image at a specified point by a specified angle.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageRotateDrawingAxis( image=any, angle=number, x=number, y=number );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| angle | number | No | The rotation angle in degrees. |  |
| x | number | No | The x coordinate for the point of rotation. The default value is 0. |  |
| y | number | No | The y coordinate for the point of rotation. The default value is 0. |  |

# Examples

```cfml
  imgObj = imageNew("",152,152,"rgb","red");
  imgObj.rotateDrawingAxis(135,71,71);
  imgObj.drawLines([0,38,76,114,152],[0,152,0,152,0],"no","no");
  cfimage(action="writeToBrowser", source=imgObj);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.rotateDrawingAxis()](../objects/image/rotatedrawingaxis.md)