# ImageRotate()

Rotates an image at a specified point by a specified angle.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageRotate( image=any, x=string, y=string, angle=string, interpolation=string );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| x | string | Yes | The x coordinate for the point of rotation. The default value is 2. | 2 |
| y | string | No | The y coordinate for the point of rotation. The default value is 2. | 2 |
| angle | string | No | The rotation angle in degrees. | 0 |
| interpolation | string | No | Type of interpolation: - nearest (default): Applies the nearest neighbor method of interpolation. Image quality is lower than the other interpolation methods, but processing is fastest. - bilinear: Applies the bilinear method of interpolation. The quality of the image is less pixelated than the default, but processing is slower. - bicubic: Applies the bicubic method of interpolation. Generally, the quality of image is highest with this method and processing is slowest. | nearest |

# Examples

```cfml
img=imageNew("",100,100,"RGB","0fb9b1");
imageRotate(img, "60");
cfimage(action="writeToBrowser",source=img);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.rotate()](../objects/image/rotate.md)