# ImageResize()

Resizes an image.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageResize( image=any, width=string, height=string, interpolation=string, blurFactor=number );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| width | string | Yes | New width of the image. If this value is blank, the width is calculated proportionately to the height. |  |
| height | string | No | New height of the image. If this value is blank, the height is calculated proportionately to the width. |  |
| interpolation | string | No | the interpolation method for resampling. You can specify a specific interpolation algorithm by name (for example, hamming), by image quality (for example, mediumQuality), or by performance (for example, highestPerformance). Valid values are: - highestQuality (default) - highQuality - mediumQuality - highestPerformance - highPerformance - mediumPerformance - nearest - bilinear - bicubic - bessel - blackman - hamming - hanning - hermite - lanczos - mitchell - quadratic | automatic |
| blurFactor | number | No | The blur factor used for resampling. The higher the blur factor, the more blurred the image (also, the longer it takes to resize the image). Valid values are 0-10. | 1 |

# Examples

```cfml
img=imageNew("",800,1200,"RGB","2d98da");
imageresize(img, "20%","100");
cfimage(action="writeToBrowser",source=img);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.resize()](../objects/image/resize.md)