# ImagePaste()

Takes two images and an (x,y) coordinate and draws the second image over the first image with the upper-left corner at coordinate (x,y).

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImagePaste( image1=any, image2=any, x=number, y=number );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image1 | any | Yes | The bottom image. |  |
| image2 | any | Yes | The image that is pasted on top of image1. |  |
| x | number | No | The x coordinate where the upper-left corner of image2 is pasted. |  |
| y | number | No | The y coordinate where the upper-left corner of image2 is pasted. |  |

# Examples

```cfml
firstImage = imageNew("",200,200,"rgb","red");
secondImage = imageNew("",200,200,"rgb","yellow");
imagepaste(firstImage,secondImage,75,75);
//Member function
//firstImage.paste(secondImage,10,10);
cfimage(action="writeToBrowser", source=firstImage);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.paste()](../objects/image/paste.md)