# ImageOverlay()

Reads two source images and overlays the second source image on the first source image.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageOverlay( source1=any, source2=any );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| source1 | any | Yes | The image that is the bottom layer in the image. |  |
| source2 | any | Yes | the image that is the top layer (overlaid on the source1 image) in the image. |  |

# Examples

```cfml
	myImg = imageNew("",152,152,"rgb","40739e");
	topImg = imageNew("",80,80,"rgb","fbc531");
	myImg.overlay(topImg);
	cfimage(action="writeToBrowser", source=myImg);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.overlay()](../objects/image/overlay.md)