# ImageNew()

Creates an image.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageNew( source=any, width=string, height=string, imageType=string, canvasColor=string );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| source | any | No | The source image path, URL, a variable that is read into the new image, or a Java buffered image. |  |
| width | string | No | The width of the new image. Valid when the height is specified and the source is not. |  |
| height | string | No | The height of the new image. Valid when the width is specified and the source is not. |  |
| imageType | string | No | The type of the image to create (Valid only when width and height are specified): - rgb - argb - grayscale *Alias: type* |  |
| canvasColor | string | No | Color of the image canvas (The default value is "black"): - Hexadecimal value of RGB color. For example, specify the color white as ##FFFFFF or FFFFFF. - String value of color (for example, "black", "red", "green"). - List of three numbers for (R,G,B) values. Each value must be in the range 0-255. |  |

# Examples

```cfml
    img = imageNew("",100,100,"rgb","yellow");
    dump(img);
    dump(ImageInfo(img));
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[Image](../objects/image.md)