# ImageGrayscale()

Converts an image to grayscale.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageGrayscale( image=any );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |

# Examples

```cfml
img=imageRead("https://hostek.com/blog/wp-content/uploads/2015/11/magician_lucee_wide.jpg");
imageGrayScale(img);
imageresize(img, "20%","200");
cfimage(action="writeToBrowser",source=img);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.grayscale()](../objects/image/grayscale.md)