# ImageGetEXIFTag()

Retrieves the specified EXIF tag in an image.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageGetEXIFTag( image=any, tagName=string );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| tagName | string | Yes | The EXIF tag name to be returned. |  |

# Examples

### Function Example

```cfml
img = imageRead('https://avatars1.githubusercontent.com/u/10973141?s=280&v=4')
	writeDump(imageGetEXIFTag(img,'width'));
	writeDump(imageGetEXIFTag(img,'height'));
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[ImageGetEXIFMetadata()](imagegetexifmetadata.md), [image.getEXIFTag()](../objects/image/getexiftag.md)