# ImageGetEXIFMetadata()

Retrieves the Exchangeable Image File Format (EXIF) headers in an image as a CFML structure.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageGetEXIFMetadata( image=any );
```

**Returns:** struct

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |

# Examples

### Function Example

```cfml
	img = imageRead('https://avatars1.githubusercontent.com/u/10973141?s=280&v=4')
	writeDump( ImageGetExifMetaData( img ) );
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[ImageGetEXIFTag()](imagegetexiftag.md), [image.getEXIFMetadata()](../objects/image/getexifmetadata.md)