# ImageFlip()

Flips an image across an axis.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageFlip( image=any, transpose=string );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| transpose | string | No | Transpose the image: - vertical (default): Flip an image across an imaginary horizontal line that runs through the center of the image. - horizontal: Flip an image across an imaginary vertical line that runs through the center of the image. - diagonal: Flip an image across its main diagonal that runs from the upper-left to the lower-right corner. - antidiagonal: Flip an image across its main diagonal that runs from the upper-right to the lower-left corner. - ("90\|180\|270"): Rotate an image clockwise by 90, 180, or 270 degrees. | vertical |

# Examples

```cfml
img=imageRead("https://avatars1.githubusercontent.com/u/10973141?s=280&v=4");
imageFlip(img,"antidiagonal");
cfimage(action="writeToBrowser",source=img);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.flip()](../objects/image/flip.md)