# ImageFilterColorMap()

These are passed to the function ImageFilters (see [ImageFilter()](imagefilter.md) documentation) which convert gray values to colors.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageFilterColorMap( type=string, lineColor1=string, lineColor2=string );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| type | string | Yes | type of the color map, possible values are: - spectrum: A colormap with the colors of the spectrum - linear: A colormap which interpolates linearly between two colors - grayscale: A grayscale colormap. Black is 0, white is 1 |  |
| lineColor1 | string | No | used only for type "linear", the color corresponding to value 0 in the colormap. *Alias: lineColour1* |  |
| lineColor2 | string | No | used only for type "linear", the color corresponding to value 1 in the colormap. *Alias: lineColour2* |  |

# Examples

```cfml
img = imageRead("https://dev.lucee.org/uploads/default/original/2X/6/63711fa0d32b7ebd71a71286b77aa555c8d034fa.jpeg");
filter = "life";
map = ImageFilterColorMap(type="spectrum");
params = {
	colormap: map,
	iterations: 20,
	newColor: "990000",
};
ImageFilter(image = img, filtername = filter, parameters = params);
imageWriteToBrowser(img);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.filterColorMap()](../objects/image/filtercolormap.md)