# ImageDrawText()

Draws a text string on an image with the baseline of the first character positioned at (x,y) in the image.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageDrawText( image=any, string=string, x=number, y=number, attributeCollection=struct );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| string | string | Yes | the text to draw. *Alias: str* |  |
| x | number | Yes | The x coordinate for the start point of the string. |  |
| y | number | Yes | The y coordinate for the start point of the string. |  |
| attributeCollection | struct | No | a structure used to specify the text characteristics. the following keys are supported: - font: The name of the font used to draw the text string. If you do not specify the font attribute, the text is drawn in the default system font. - size: The font size for the text string. The default value is 10 points. - style: The style to apply to the font ( bold,italic,boldItalic,plain (default) ). - strikethrough: a boolean that specify whether strikethrough is applied to the text image, default is false. - underline: a boolean that specify whether underline is applied to the text image, default is false. |  |

# Examples

```cfml
img=imageNew("",300,300,"RGB","45aaf2");
style={size="26",style="Italic"};
ImageDrawText(img,"I love lucee",75,120,style);
cfimage(action="writeToBrowser",source=img);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.drawText()](../objects/image/drawtext.md)