# ImageDrawRoundRect()

Draws a rectangle with rounded corners.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageDrawRoundRect( image=any, x=number, y=number, width=number, height=number, arcWidth=number, arcHeight=number, filled=boolean );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| x | number | Yes | The x coordinate of the rectangle. |  |
| y | number | Yes | The y coordinate of the rectangle. |  |
| width | number | Yes | The width of the rectangle. |  |
| height | number | Yes | The height of the rectangle. |  |
| arcWidth | number | Yes | The horizontal diameter of the arc at the four corners. |  |
| arcHeight | number | Yes | The vertical diameter of the arc at the four corners. |  |
| filled | boolean | No | Specify whether the rectangle is filled: - true: The rectangle is filled with the specified drawing color. - false (default): Only the outline of the rectangle is drawn. |  |

# Examples

```cfml
img=imageNew("",200,200,"RGB","b71540");
imageDrawRoundRect(img,45,50,75,125,25,25);
cfimage(action="writeToBrowser",source=img);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.drawRoundRect()](../objects/image/drawroundrect.md)