# ImageDrawRect()

Draws a rectangle.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageDrawRect( image=any, x=number, y=number, width=number, height=number, filled=boolean );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| x | number | Yes | The x coordinate of the rectangle. |  |
| y | number | Yes | The y coordinate of the rectangle. |  |
| width | number | Yes | The width of the rectangle. |  |
| height | number | Yes | The height of the rectangle. |  |
| filled | boolean | No | Specify whether the rectangle is filled: - true: The rectangle is filled with the specified drawing color. - false (default): Only the outline of the rectangle is drawn. |  |

# Examples

```cfml
img=imageNew("",200,200,"RGB","fa983a");
imageDrawRect(img,45,50,75,125);
cfimage(action="writeToBrowser",source=img);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.drawRect()](../objects/image/drawrect.md)