# ImageDrawQuadraticCurve()

Draws a curved line. The curve is controlled by a single point.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageDrawQuadraticCurve( image=any, x1=number, y1=number, ctrlx=number, ctrly=number, x2=number, y2=number );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| x1 | number | Yes | The x coordinate of the start point of the quadratic curve segment. |  |
| y1 | number | Yes | The y coordinate of the start point of the quadratic curve segment. |  |
| ctrlx | number | Yes | The x coordinate of the first control point of the quadratic curve segment. |  |
| ctrly | number | Yes | The y coordinate of the first control point of the quadratic curve segment. |  |
| x2 | number | Yes | The x coordinate of the end point of the quadratic curve segment. |  |
| y2 | number | Yes | The y coordinate of the end point of the quadratic curve segment. |  |

# Examples

```cfml
img=imageNew("",100,100,"RGB","a29bfe");
ImageDrawQuadraticCurve(img,0,80,50,0,75,20);
cfimage(action="writeToBrowser",source=img);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.drawQuadraticCurve()](../objects/image/drawquadraticcurve.md)