# ImageDrawPoint()

Draws a point at the specified (x,y) coordinate.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageDrawPoint( image=any, x=number, y=number );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| x | number | Yes | The x coordinate of the point. |  |
| y | number | Yes | The y coordinate of the point. |  |

# Examples

```cfml
img=imageNew("",100,100,"RGB","3c6382");
imageDrawPoint(img,45,50);
cfimage(action="writeToBrowser",source=img);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.drawPoint()](../objects/image/drawpoint.md)