# ImageDrawOval()

Draws an oval.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageDrawOval( image=any, x=number, y=number, width=number, height=number, filled=boolean );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| x | number | Yes | The x coordinate of the upper left corner of the oval to draw. |  |
| y | number | Yes | The y coordinate of the upper left corner of the oval to draw. |  |
| width | number | Yes | The width of the oval to draw. |  |
| height | number | Yes | The height of the oval to draw. |  |
| filled | boolean | No | Specify whether the oval is filled: - true: The oval is filled with the specified drawing color. - false (default): Only the outline of the oval is drawn. |  |

# Examples

```cfml
img=imageNew("",200,200,"RGB","e55039");
imageDrawOval(img,60,50,50,100,"no");
cfimage(action="writeToBrowser",source=img);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.drawOval()](../objects/image/drawoval.md)