# ImageDrawLines()

Draws a sequence of connected lines defined by arrays of x and y coordinates.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageDrawLines( image=any, xcoords=array, ycoords=array, isPolygon=boolean, filled=boolean );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| xcoords | array | Yes | An array of x coordinates. |  |
| ycoords | array | Yes | An array of y coordinates. |  |
| isPolygon | boolean | No | Specify whether the lines form a polygon: - true: The lines are connected to form a polygon. - false (default): The lines do not form a polygon. |  |
| filled | boolean | No | Specify whether the polygon is filled: - true: The polygon is filled with the specified drawing color. - false (default): Only the outline of the polygon is drawn. |  |

# Examples

```cfml
img=imageNew("",200,200,"RGB","4a69bd");
imageDrawLines(img,[10,50,100,50],[100,10,100,152],"yes","no");
cfimage(action="writeToBrowser",source=img);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.drawDrawLines()](../objects/image/drawdrawlines.md)