# ImageDrawLine()

Draws a single line defined by two sets of x and y coordinates on an image.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageDrawLine( image=any, x1=number, y1=number, x2=number, y2=number );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| x1 | number | Yes | The x coordinate for the start point of the line. |  |
| y1 | number | Yes | The y coordinate for the start point of the line. |  |
| x2 | number | Yes | The x coordinate for the end point of the line. |  |
| y2 | number | Yes | The y coordinate for the end point of the line. |  |

# Examples

```cfml
img=imageNew("",200,200,"RGB","38ada9");
imageDrawLine(img,10,10,100,180);
cfimage(action="writeToBrowser", source=img);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.drawLine()](../objects/image/drawline.md)