# ImageDrawCubicCurve()

Draws a cubic curve.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageDrawCubicCurve( image=any, x1=number, y1=number, ctrlx1=number, ctrly1=number, ctrlx2=number, ctrly2=number, x2=number, y2=number );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| x1 | number | Yes | The x coordinate of the start point of the cubic curve segment. |  |
| y1 | number | Yes | The y coordinate of the start point of the cubic curve segment. |  |
| ctrlx1 | number | Yes | The x coordinate of the first control point of the cubic curve segment. |  |
| ctrly1 | number | Yes | The y coordinate of the first control point of the cubic curve segment. |  |
| ctrlx2 | number | Yes | The x coordinate of the second control point of the cubic curve segment. |  |
| ctrly2 | number | Yes | The y coordinate of the second control point of the cubic curve segment. |  |
| x2 | number | Yes | The x coordinate of the end point of the cubic curve segment. |  |
| y2 | number | Yes | The y coordinate of the end point of the cubic curve segment. |  |

# Examples

```cfml
img=imageNew("",100,100,"RGB","3c6382");
imageDrawCubicCurve(img,0,0,45,15,50,75,0,100);
cfimage(action="writeToBrowser",source=img);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.drawCubicCurve()](../objects/image/drawcubiccurve.md)