# ImageDrawBeveledRect()

Draws a rectangle with beveled edges.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageDrawBeveledRect( image=any, x=number, y=number, width=number, height=number, raised=boolean, filled=boolean );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| x | number | Yes | The x coordinate of the rectangle. |  |
| y | number | Yes | The y coordinate of the rectangle. |  |
| width | number | Yes | The width of the rectangle. |  |
| height | number | Yes | The height of the rectangle. |  |
| raised | boolean | No | Specify whether the rectangle appears raised above the surface or sunk into the surface: - true: The rectangle is raised. - false (default): The rectangle is sunk. |  |
| filled | boolean | No | Specify whether the rectangle is filled: - true: The rectangle is filled with the specified drawing color. - false (default): Only the outline of the rectangle is drawn. |  |

# Examples

```cfml
img=imageRead("https://avatars1.githubusercontent.com/u/10973141?s=280&v=4")
imageDrawBeveledRect(img,50,50,50,100,"yes");
cfimage(action="writeToBrowser", source=img);
writeOutput("<br>");
imageDrawBeveledRect(img,50,50,50,100,"yes","yes");//FIlled rect
cfimage(action="writeToBrowser", source=img);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.drawBeveledRect()](../objects/image/drawbeveledrect.md)