# ImageDrawArc()

Draws a circular or elliptical arc.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageDrawArc( image=any, x=number, y=number, width=number, height=number, startAngle=number, arcAngle=number, filled=boolean );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| x | number | Yes | The x coordinate of the upper-left corner of the arc. |  |
| y | number | Yes | The y coordinate of the upper-left corner of the arc. |  |
| width | number | Yes | The width of the arc. |  |
| height | number | Yes | The height of the arc. |  |
| startAngle | number | Yes | The beginning angle in degrees. |  |
| arcAngle | number | Yes | The angular extent of the arc, relative to the start angle. |  |
| filled | boolean | No | Specify whether the arc is filled: - true: The arc is filled with the specified drawing color. - false (default): Only the outline of the arc is drawn. |  |

# Examples

```cfml
img=imageRead("https://avatars1.githubusercontent.com/u/10973141?s=280&v=4")
imageDrawArc(img,50,50,100,100,90,180,"yes");
cfimage(action="writeToBrowser", source=img);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.drawArc()](../objects/image/drawarc.md)