# ImageCrop()

Crops an image to a specified rectangular area.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageCrop( image=any, x=number, y=number, width=number, height=number );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| x | number | Yes | The X origin of the crop area. |  |
| y | number | Yes | The Y origin of the crop area. |  |
| width | number | Yes | The width of the crop area. |  |
| height | number | Yes | The height of the crop area. |  |

# Examples

```cfml
img=imageRead("https://avatars1.githubusercontent.com/u/10973141?s=280&v=4")
imageCrop(img,50,10,100,100);
cfimage(action="writeToBrowser", source=img);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.crop()](../objects/image/crop.md)