# ImageCopy()

Copies a rectangular area of an image.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageCopy( image=any, x=number, y=number, width=number, height=number, dx=number, dy=number );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| x | number | Yes | The x coordinate of the source rectangle. |  |
| y | number | Yes | The y coordinate of the source rectangle. |  |
| width | number | Yes | The width of the source rectangle. |  |
| height | number | Yes | The height of the source rectangle. |  |
| dx | number | No | The x coordinate of the destination rectangle. | -999 |
| dy | number | No | The y coordinate of the destination rectangle. | -999 |

# Examples

```cfml
	newImg = imageNew("",200,200,"rgb","red");
	copiedImg = newImg.copy(50,50,50,50);
	cfimage(action="writeToBrowser", source=copiedImg);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.copy()](../objects/image/copy.md)