# ImageClearRect()

Clears the specified rectangle by filling it with the background color of the current drawing surface.

The color is set via [ImageSetBackgroundColor()](imagesetbackgroundcolor.md)

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageClearRect( image=object, x=number, y=number, width=number, height=number );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | object | Yes | The image on which this operation is performed. *Alias: name* |  |
| x | number | Yes | The X coordinate of the rectangle to clear. |  |
| y | number | Yes | The Y coordinate of the rectangle to clear. |  |
| width | number | Yes | The width of the rectangle to clear. |  |
| height | number | Yes | The height of the rectangle to clear. |  |

# Examples

```cfml
img=imageRead("https://avatars1.githubusercontent.com/u/10973141?s=280&v=4")
ImageClearRect(img,180,50,20,30);
cfimage(action="writeToBrowser", source=img);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[ImageSetBackgroundColor()](imagesetbackgroundcolor.md), [image.clearRect()](../objects/image/clearrect.md)