# ImageCaptcha()

Creates a captcha image

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageCaptcha( text=string, height=numeric, width=numeric, difficulty=string, fonts=any, fontsize=numeric, fontcolor=string );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| text | string | Yes | Text in the captcha. |  |
| height | numeric | Yes | Height of the captcha. |  |
| width | numeric | Yes | Width of the captcha. |  |
| difficulty | string | No | Level of complexity of the CAPTCHA text. Specify one of the following levels of text distortion: low, medium, high | low |
| fonts | any | No | One or more valid fonts to use for the CAPTCHA text, as an array or as string list (separate multiple fonts with commas). Lucee supports only the system fonts that the JDK can recognize. For example, TTF fonts in the Windows directory are supported on Windows. *Alias: font* | arial |
| fontsize | numeric | No | font size of the text in the CAPTCHA image. *Alias: size* | 24 |
| fontcolor | string | No | font color of the text in the CAPTCHA image. *Alias: color* | black |

# Examples

```cfml
	imagewritetobrowser(imagecaptcha( "abcdec", 100, 300, "low"));
	imagewritetobrowser(imagecaptcha( "abcdec", 100, 300, "medium"));
	imagewritetobrowser(imagecaptcha( "abcdec", 100, 300, "high"));
```







# Categories

[Image manipulation](../../categories/image.md)