# ImageAddBorder()

Adds a rectangular border around the outside edge of an image.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageAddBorder( image=any, thickness=number, color=string, borderType=string );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| thickness | number | No | Thickness of the border in pixels. The default value is 1. The border is added to the outside edge of the image; the image area is increased accordingly. | 1 |
| color | string | No | Optional. Border color. The default border color is black. See Usage. Only valid if the borderType is not specified or if borderType = "constant". *Alias: colour* | black |
| borderType | string | No | The type of border: - zero: Sets the border color to black. - constant: Sets the border to the specified color (default). - copy: Sets sample values to copies of the nearest valid pixel. For example, pixels to the left of the valid rectangle assume the value of the valid edge pixel in the same row. Pixels both above and to the left of the valid rectangle assume the value of the upper-left pixel. - reflect: Mirrors the edges of the source image. For example, if the left edge of the valid rectangle is located at x = 10, pixel (9, y) is a copy of pixel (10, y) and pixel (6, y) is a copy of pixel (13, y). - wrap: Tiles the source image in the plane. *Alias: type, border* | constant |

# Examples

```cfml
img=imageRead("https://avatars1.githubusercontent.com/u/10973141?s=280&v=4")
imageAddBorder(img,10,"red");
cfimage(action="writeToBrowser", source=img);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.addBorder()](../objects/image/addborder.md)