# HtmlParse()

parse the given HTML (not only XHTML) as XML Object, work similar to [XmlParse()](xmlparse.md), but this function is very forgiving with the syntax.

You can then use [XmlSearch()](xmlsearch.md) to query to xml object

```
HtmlParse( html=string, caseSensitive=boolean );
```

**Returns:** xml

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| html | string | Yes | A string or a variable that contains one, with HTML to be parsed *Alias: string, text* |  |
| caseSensitive | boolean | No | Maintains the case of document elements and attributes |  |

# Examples

```cfml
content = "HI <body><p>Hello</p></body> !!!";
writeDump(htmlParse(content));
writeoutput(htmlParse('<html><body>aaa<br>bbb</body></html>'));
```







# Categories

[HTML](../../categories/html.md), [Parsing](../../categories/parsing.md)

# See Also

[XmlParse()](xmlparse.md), [XmlSearch()](xmlsearch.md)