# HTMLEditFormat()

Replaces special characters in a string with their HTML-escaped equivalents.   [version]
HTML version to use is currently ignored.

-1: The latest implementation of HTML

2.0: HTML 2.0 (Default)

3.2: HTML 3.2

4.0: HTML 4.0

```
HTMLEditFormat( string=string, version=number );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | A string or a variable that contains one. |  |
| version | number | No | HTML version to use: -1: The latest implementation of HTML 2.0: HTML 2.0 (default) 3.2: HTML 3.2 |  |

# Examples

```cfml
testString="Hello !!!
<This text is inside of angle brackets>
This text is outside of angle brackets !!!" ;
writeoutput(testString);
writeoutput('<h5>HTMLEditFormat</h5>' & HTMLEditFormat(testString));
```







# Categories

[Formatting](../../categories/formatting.md), [HTML](../../categories/html.md), [Strings](../../categories/string.md), [Encode/Decode](../../categories/esapi.md)

# See Also

[EncodeForHTML()](encodeforhtml.md), [ESAPIEncode()](esapiencode.md), [HTMLCodeFormat()](htmlcodeformat.md)