# HTMLCodeFormat()

Replaces special characters in a string with their HTML-escaped
equivalents and inserts `<pre>` and `</pre>` tags at the beginning
and end of the string.

[version] HTML version to use. Currently ignored.

- -1: The latest implementation of HTML
- 2.0: HTML 2.0 (Default)
- 3.2: HTML 3.2

```
HTMLCodeFormat( string=string, version=number );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | A string or a variable that contains one. |  |
| version | number | No | HTML version to use: -1: The latest implementation of HTML 2.0: HTML 2.0 (default) 3.2: HTML 3.2 |  |

# Examples

```cfml
testString="Hello !!!
<This text is inside of angle brackets>
This text is outside of angle brackets !!!" ;
writeoutput(testString);
writeoutput('<h5>HTMLCodeFormat</h5>' & HTMLCodeFormat(testString));
```







# Categories

[HTML](../../categories/html.md), [Strings](../../categories/string.md), [Formatting](../../categories/formatting.md)

# See Also

[EncodeForHTML()](encodeforhtml.md), [ESAPIEncode()](esapiencode.md), [HTMLEditFormat()](htmleditformat.md)