# Hour()

Gets the current hour of the day. Ordinal value of the hour, in the range 0 - 23.

```
Hour( Date=datetime, timezone=timezone );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| Date | datetime | Yes | date object; for example, [now()](now.md) |  |
| timezone | timezone | No | A datetime object is independent of a specific timezone; it is only an offset in milliseconds from `1970-1-1 00.00:00 UTC` (Coordinated Universal Time). The timezone only comes into play when you need specific information like hours in a day, minutes in a hour or which day it is as these calculations depend on the timezone. A timezone must be specified in order to translate the date object to something else. If you do not provide the timezone in the function call, it will default to the timezone specified in the Lucee Administrator (Settings/Regional), or the timezone specified for the current request using the function [setTimezone()](settimezone.md). You can find a list of all available timezones in the Lucee administrator (Settings/Regional). Some examples of valid timezones include: - AGT (for time in Argentina) - Europe/Zurich (for time in Zurich/Switzerland) - HST (Hawaiian Standard Time in the USA) - JVM (JVM / Server Default Timezone) |  |

# Examples

```cfml
	writeDump(hour(now()))//Server date
	dt=createDateTime(2018, 07, 30,06,15,45);
	writeDump(hour(dt));//6
```







# Categories

[Date and time](../../categories/datetime.md)

# See Also

[datetime.hour()](../objects/datetime/hour.md)