# HMAC()

Creates a hash-based message authentication code (HMAC) for the given message combined with a given secret key using an optional algorithm and encoding.

HMACs are used to verify the data integrity and authenticity of a transmitted message.

The hash function used by the HMAC function depends on the algorithm specified.

```
HMAC( message=object, key=object, algorithm=string, encoding=string );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| message | object | Yes | The message to be hashed. Can be a string or a byte array. |  |
| key | object | Yes | The secret cryptographic key to be combined with the message and hashed. Can be a string or a byte array. |  |
| algorithm | string | No | The algorithm to use for hashing your input, default is `HmacMD5`. The available algorithms (depending on your JVM) are - HmacSHA512 - HmacSHA3-384 - HmacSHA384 - HmacSHA3-512 - HmacSHA512/256 - HmacSHA3-224 - HmacSHA512/224 - HmacSHA3-256 - HmacSHA256 - SslMacMD5 - HmacSHA224 - SslMacSHA1 - HmacSHA1 - HmacMD5 | HmacMD5 |
| encoding | string | No | The character encoding to use when converting the message to bytes. Must be a character encoding name recognized by the Java runtime. * utf-8 * iso-8859-1 * windows-1252 * us-ascii * shift_jis * iso-2022-jp * euc-jp * euc-kr * big5 * euc-cn * utf-16 *Alias: charset* |  |

# Examples

```cfml

    message = 'this is a test';
    key = 'ABC123';

    // Using the required fields only
    result = HMAC( message, key );
    writeDump( result ); // 776770430C93778AD6F91B43A4A30B69


    // Using the optional algorithm parameter (HmacSHA1)
    algorithm = 'HmacSHA1';
    result = HMAC( message, key, algorithm );
    writeDump( result ); // 049E53BAE339C4A05587D7BBBA2857548E8FC327


    // Using the optional algorithm parameter (HmacSHA256)
    algorithm = 'HmacSHA256';
    result = HMAC( message, key, algorithm );
    writeDump( result ); // 0503949602EDE3FF61C84F4CE51C99EEA2961CAA144AEE552F7D120AD6A60D7D


    // Using the optional encoding parameter (UTF-8)
    encoding = 'UTF-8';
    result = HMAC( message, key, algorithm, encoding );
    writeDump( result ); // 0503949602EDE3FF61C84F4CE51C99EEA2961CAA144AEE552F7D120AD6A60D7D

```







# Categories

[Cryptography](../../categories/crypto.md)