# Hash40()

This function only exists for backward compatibility to Lucee 4.0 or older version that has produced an incorrect result for non us-ascii characters,
Only use this function for backward compatibility, use [Hash()](hash.md) instead.

Converts a variable-length string to a 32-byte, hexadecimal string, using the MD5 algorithm.

(It is not possible to convert the hash result back to the source string.) 32-byte, hexadecimal string.

```
Hash40( input=any, algorithm=string, encoding=string, numIterations=number );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| input | any | Yes | String to hash. |  |
| algorithm | string | No | The algorithm to use to hash the string. Supported are the following algorithms: - CFMX_COMPAT: generating a hash string using classic CFML algorithm. - MD5: (default) Generates a 32-character, hexadecimal string, using the MD5 algorithm. - SHA: Generates a 28-character string using the Secure Hash Standard SHA-1 algorithm specified by Nation Institute of Standards and Technology (NIST) FIPS-180-2. - SHA-256: Generates a 44-character string using the SHA-256 algorithm specified by FIPS-180-2. - SHA-384: Generates a 64-character string using the SHA-384 algorithm specified by FIPS-180-2. - SHA-512: Generates an 88-character string using the SHA-1 algorithm specified by FIPS-180-2. |  |
| encoding | string | No | A string specifying the encoding to use when converting the string to byte data used by the hash algorithm. |  |
| numIterations | number | No | number of iterations; default is 1. |  |

# Examples

```cfml
my_string = "backward compatibility to Lucee 4.0";
hashed_string = hash40(input = my_string, algorithm = "SHA-512", numIterations = 20);
dump(hashed_string); //550C0FB966EEDDEFD49743C5D1880239D221DC3811216515630EB6A6BAA4B0A2845C445EFDCB5B5563CDDDFE7EE13DF67AA9E8670A99EA997E306EF0F5630092
```







# Categories

[Cryptography](../../categories/crypto.md)

# See Also

[Hash()](hash.md)