# GetVFSMetaData()

Returns metadata about the Virtual File system (VFS)

```
GetVFSMetaData( scheme=string );
```

**Returns:** struct

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| scheme | string | Yes | the scheme of the virtual filesystem - ram - file - s3 - http - https - zip - tar |  |

# Examples

```cfml
    loop list="ram,file,s3,http,https,zip,tar" item="vfs"{
        dump(var=getVFSMetaData(vfs), label="#vfs#");
    }
```







# Categories

[File handling](../../categories/files.md), [S3 ](../../categories/s3.md), [Lucee Server related Tags, Functions and Guides](../../categories/server.md)

# See Also

[Virtual File Systems](../../recipes/virtual-file-system.md)