# GetTotalSpace()

Returns the size of the partition named by this abstract pathname.

```
GetTotalSpace( file=object );
```

**Returns:** numeric

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| file | object | Yes | file path *Alias: filepath, path* |  |

# Examples

```cfml
try{
	totalDiskSpace = getTotalSpace("c:");
	totalRAMSpace = getTotalSpace("c:");
	writeOutput('Total Hard Disk Space : ' & DecimalFormat(totalDiskSpace / (1024 * 1024 * 1024)));
	writeoutput('<br>');
	writeOutput('Total Application RAM Memory : ' & DecimalFormat(totalRAMSpace / (1024 * 1024)));
}
catch(any e){
	writeOutput(cfcatch.message);
	writeOutput(cfcatch.detail);
}
```







# Categories

[File handling](../../categories/files.md), [Lucee Server related Tags, Functions and Guides](../../categories/server.md)

# See Also

[GetFreeSpace()](getfreespace.md)