# GetSystemPropOrEnvVar()

Return the list of supported system properties or env vars Lucee supports.

Lucee treats the following config as identical, but System Properties take precedence.

- `lucee.admin.enabled` (Java System Property)
- `LUCEE_ADMIN_ENABLED` (Environment variables)

These values also available via the `server` scope

- `server.system.environment`
- `server.system.properties`

**Introduced:** 6.2.1.23

```
GetSystemPropOrEnvVar( property=string );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| property | string | No | Optional, when set, the value of the property as configured is returned |  |

# Examples

```cfml
// List all system properties  
<cfdump var="#GetSystemPropOrEnvVar()#" />  

// Return the configured value; otherwise, return empty  
<cfdump var="#GetSystemPropOrEnvVar('lucee.cache.variableKeys')#" />  

```







# Categories

[Lucee Server related Tags, Functions and Guides](../../categories/server.md)

# See Also

[Environment Variables / System Properties for Lucee](../../recipes/environment-variables-system-properties.md), [Full list of System Properties and Enviromment Variables](../environment-variables-system-properties.md)