# GetPageContext()

Gets the current [PageContext](https://javadoc.lucee.org/lucee/runtime/PageContext.html) object that provides access to page attributes and configuration, request and response objects.

```
GetPageContext( );
```

**Returns:** any

*This function does not take any arguments.*

# Examples

```cfml
echo("Click to expand");
    pc = getPageContext();
    dump(var=pc, label="PageContext", expand=false);
    dump(var=pc.getCFMLFactory(), label="CFMLFactory", expand=false);
    dump(var=pc.getCFMLFactory().getEngine(), label="Engine",expand=false);
    if( listFirst(server.lucee.version,".") lte 5)
        dump(var=pc.getCFMLFactory().getConfig(), label="Config",expand=false);
    else
        dump(var=pc.getCFMLFactory().getConfigServer(), label="ConfigServer",expand=false);
    dump(var=pc.getCFMLFactory().getScopeContext(), label="ScopeContext",expand=false);
```







# Categories

[Debugging](../../categories/debugging.md), [Java](../../categories/java.md), [Lucee Server related Tags, Functions and Guides](../../categories/server.md)

# See Also

[GetContextInfo()](getcontextinfo.md), [GetHTTPRequestData()](gethttprequestdata.md)