# GetLocale()

Gets the current geographic/language locale value.

To set the default display format of date, time, number, and currency values in a CFML application session, you use the [SetLocale()](setlocale.md) function.

```
GetLocale( );
```

**Returns:** string

*This function does not take any arguments.*

# Examples

```cfml
    	var n = 1234.56;
	writeOutput( getlocale() );
	dump( dateTimeFormat( now() ) );
	dump( LSdateTimeFormat( now() ) );
	dump( numberFormat( n ) );
	dump( LSnumberFormat( n ));

	writeOutput(' To ');
	setLocale( 'french(switzerland)' );

	writeOutput( getlocale() );
	dump( dateTimeFormat( now() ) );
	dump( LSdateTimeFormat( now() ) );
    	dump( numberFormat( n ) );
	dump( LSnumberFormat( n ) );

	writeOutput(' To ');
	setLocale( 'German' );

	writeOutput( getlocale() );
	dump( dateTimeFormat( now() ) );
	dump( LSdateTimeFormat( now() ) );
    	dump( numberFormat( n ) );
	dump( LSnumberFormat( n ) );
```







# Categories

[Date and time](../../categories/datetime.md), [Internationalization](../../categories/internationalization.md)

# See Also

[GetLocaleInfo()](getlocaleinfo.md), [SetLocale()](setlocale.md), [Locale](../objects/locale.md)