# GetFreeSpace()

Returns the number of unallocated bytes in the partition named by this abstract path name.

The returned number of unallocated bytes is a hint, but not a guarantee, that it is possible to use most or any of these bytes.

The number of unallocated bytes is most likely to be accurate immediately after this call.

It is likely to be made inaccurate by any external I/O operations including those made on the system outside of this virtual machine.

This method makes no guarantee that write operations to this file system will succeed.

```
GetFreeSpace( file=object );
```

**Returns:** numeric

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| file | object | Yes | file path *Alias: path, filePath* |  |

# Examples

```cfml
try{
	freeDiskSpace = getFreeSpace("c:");
	freeRAMSpace = getFreeSpace("c:");
	writeOutput('Free Hard Disk Space : ' & DecimalFormat(freeDiskSpace / (1024 * 1024 * 1024)));
	writeoutput('<br>');
	writeOutput('Free Application RAM Memory : ' & DecimalFormat(freeRAMSpace / (1024 * 1024)));
}
catch(any e){
	writeOutput(cfcatch.message);
	writeOutput(cfcatch.detail);
}
```







# Categories

[File handling](../../categories/files.md), [Lucee Server related Tags, Functions and Guides](../../categories/server.md)

# See Also

[GetTotalSpace()](gettotalspace.md)