# GetFileInfo()

Retrieves more detailed information about a file than [FileInfo()](fileinfo.md) but doesn't calculate a checksum, so it's faster.

```
GetFileInfo( file=any );
```

**Returns:** struct

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| file | any | Yes | file path *Alias: filePath, source* |  |

# Examples

```cfml
file= getTempFile(getTempDirectory(),"demo");
dump(var=getFileInfo(file), label="GetFileInfo");
dump(var=FileInfo(file), label="FileInfo");
```







# Categories

[File handling](../../categories/files.md)

# See Also

[DirectoryInfo()](directoryinfo.md), [DirectoryList()](directorylist.md), [FileInfo()](fileinfo.md)