# GetAuthUser()

Gets the name of an authenticated user.

```
GetAuthUser( );
```

**Returns:** string

*This function does not take any arguments.*

# Examples

```cfml
<cflogin>
	// tag version
	<cfloginuser name = "test" password = "password" roles = "user,admin,editor">
</cflogin>
<cfdump var="#getAuthUser()#" /> <!--- "mister_user" --->
```

```cfml
//script version
login {
     loginuser name = "mister_user" password = "password_too" roles = "user,editor";
}
dump(getAuthUser()); // "mister_user"
```







# See Also

[GetUserRoles()](getuserroles.md), [<cflogin>](../tags/login.md), [<cfloginuser>](../tags/loginuser.md)