# GenerateSecretKey()

Gets a secure key value for use in the encrypt function.

```
GenerateSecretKey( algorithm=string, keySize=number );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| algorithm | string | Yes | The encryption algorithm for which to generate the key. The available algorithms (depending on your JVM) are - HmacSHA3-224 - HmacSHA384 - HmacSHA512/224 - HmacSHA512 - HmacSHA512/256 - HmacSHA3-512 - HmacSHA3-256 - HmacSHA3-384 - HmacSHA224 - ARCFOUR - Blowfish - HmacSHA256 - HmacSHA1 - AES - HmacMD5 - DESede - DES - RC2 - ChaCha20 |  |
| keySize | number | No | Number of bits requested in the key for the specified algorithm. |  |

# Examples

```cfml
	ex={};
	ex.algo="RC4";
	ex.value="554122";
	ex.key=GenerateSecretKey(ex.algo);
	ex.enc=Encrypt(ex.value, ex.key, ex.algo);
	ex.dec=Decrypt(ex.enc, ex.key, ex.algo);
	dump(ex);
```







# Categories

[Cryptography](../../categories/crypto.md)

# See Also

[Encrypt()](encrypt.md)