# GenerateRSAkeys()

Generates a secure key (private and public) for use in the encrypt function with the RSA algorithm.

```
GenerateRSAkeys( key_size=number );
```

**Returns:** struct

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| key_size | number | No | Number of bits to use for the generated Keys. | 1024 |

# Examples

```cfml
key=generateRSAKeys();
dump(key);

raw="Susi Sorglos f�hnte Ihr Haar";
enc=encrypt(raw,key.private,"rsa");
dec=decrypt(enc,key.public,"rsa");
dump(enc);
dump(dec);

enc=encrypt(raw,key.public,"rsa");
dec=decrypt(enc,key.private,"rsa");
dump(enc);
dump(dec);
```







# Categories

[Cryptography](../../categories/crypto.md)

# See Also

[Encryption/Decryption with RSA public and private keys](../../recipes/encryption_decryption.md), [Decrypt()](decrypt.md), [Encrypt()](encrypt.md)