# GeneratePBKDFkey()

Implementation of Password-Based Key-Derivation Function (PBKDF).

**Introduced:** 5.0.0.0

```
GeneratePBKDFkey( algorithm=string, passphrase=string, salt=string, iterations=numeric, keySize=numeric );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| algorithm | string | Yes | Hashing algorithm used for generating key Example Values: - PBKDF2WithHmacSHA1 - PBKDF2WithHmacSHA384 - PBKDF2WithHmacSHA512/256 - PBKDF2WithHmacSHA256 - PBKDF2WithHmacSHA512/224 - PBKDF2WithHmacSHA224 - PBKDF2WithHmacSHA512 |  |
| passphrase | string | Yes | Passphrase to be hashed. |  |
| salt | string | Yes | A random salt. It is recommended that you used something like the `GenerateSecretKey` function to generate a random salt, for example `GenerateSecretKey( 'AES' , '256' )`. |  |
| iterations | numeric | No | The number of PBKDF iterations to perform. A minimum recommended value is 1000, however a value between 50,000 and 100,000 is recommended. You can also make this a random value, using something like the `randRange()` function, for example `randRange(50000, 100000, 'SHA1PRNG')`. | 4096 |
| keySize | numeric | No | The length in bytes of the key to generate. | 128 |

# Examples

```cfml
	dump(generatePBKDFKey("PBKDF2WithHmacSHA1", "secret", "salty", 5000, 128));// Y0MCpCe3zb0CNJvyXNUWEQ==
```







# Categories

[Cryptography](../../categories/crypto.md)