# GenerateArgon2Hash()

Returns hash of input using Argon2.

**Introduced:** 5.3.8.18

**Requires Extension:** [Argon2 Extension](https://download.lucee.org/#7891D723-8F78-45F5-B7E333A22F8467CA)

```
GenerateArgon2Hash( input=string, variant=string, parallelismFactor=number, memoryCost=number, iterations=number );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| input | string | Yes | Input string. |  |
| variant | string | No | Either Argon2i, Argon2d or Argon2id | argon2i |
| parallelismFactor | number | No | Degrees of parallelism, a number between 1 and 10. | 1 |
| memoryCost | number | No | A number between 8 and 100000. | 8 |
| iterations | number | No | A number between 1 and 20. | 1 |

# Examples

```cfml
    secret = createUUID();
    dump(var=secret, label="input string");
    
    hashed = generateArgon2Hash(secret);
    dump(var=hashed, label="generateArgon2Hash");
    
    decoded= argon2checkhash(secret, hashed);
    dump(var=decoded, label="argon2checkhash matches");
```







# Categories

[Cryptography](../../categories/crypto.md)

# See Also

[Argon2CheckHash()](argon2checkhash.md)