# FormatBaseN()

Converts a number to a string, formatted in the base specified by radix.

```
FormatBaseN( number=number, radix=number );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| number | number | Yes | Number to convert |  |
| radix | number | Yes | Base of the result |  |

# Examples

```cfml
<cfoutput>
  #formatBaseN( 15, 2  )# <!--- 1111 (binary) --->
  #formatBaseN( 15, 16 )# <!--- f (hexadecimal) --->
  #formatBaseN( 15, 8  )# <!--- 17 (octal) --->
</cfoutput>
```

### Max value limitation

Please note that the value to convert is limited to a maximum equal to `java.lang.Integer.MAX_VALUE`. Values greater than this will produce unexpected results. i.e.

```cfm
<cfset max = CreateObject( "java", "java.lang.Integer" ).MAX_VALUE >
<cfoutput>
  #formatBaseN( max  , 16 )# <!---  7fffffff (correct) --->
  #formatBaseN( max+1, 16 )# <!---  7fffffff (incorrect) --->
</cfoutput>
```







# Categories

[Math](../../categories/math.md), [Numbers](../../categories/number.md)

# See Also

[InputBaseN()](inputbasen.md), [numeric.formatBaseN()](../objects/numeric/formatbasen.md)