# FirstDayOfMonth()

Determines the ordinal (day number, in the year) of the first day of the month in which a given date falls.

```
FirstDayOfMonth( date=datetime, timezone=timezone );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| date | datetime | Yes | date object; for example, [now()](now.md) |  |
| timezone | timezone | No | A datetime object is independent of a specific timezone; it is only an offset in milliseconds from `1970-1-1 00.00:00 UTC` (Coordinated Universal Time). The timezone only comes into play when you need specific information like hours in a day, minutes in a hour or which day it is as these calculations depend on the timezone. A timezone must be specified in order to translate the date object to something else. If you do not provide the timezone in the function call, it will default to the timezone specified in the Lucee Administrator (Settings/Regional), or the timezone specified for the current request using the function [setTimezone()](settimezone.md). You can find a list of all available timezones in the Lucee administrator (Settings/Regional). Some examples of valid timezones include: - AGT (for time in Argentina) - Europe/Zurich (for time in Zurich/Switzerland) - HST (Hawaiian Standard Time in the USA) - JVM (JVM / Server Default Timezone) |  |

# Examples

```cfml
	dump(firstDayOfMonth(now()));
	dump(firstDayOfMonth('03/05/2018'));//60

	//Member function
	d1=createDate(2018,02,25);
	dump(d1.firstDayOfMonth());//32
	dump(now().firstDayOfMonth());
```







# Categories

[Date and time](../../categories/datetime.md)

# See Also

[datetime.firstDayOfMonth()](../objects/datetime/firstdayofmonth.md)